(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26638,        834]*)
(*NotebookOutlinePosition[     30780,        979]*)
(*  CellTagsIndexPosition[     30736,        975]*)
(*WindowFrame->Palette*)



Notebook[{

Cell[CellGroupData[{
Cell["Arithmetic and Numbers", "Section"],

Cell[BoxData[GridBox[{
      {
        ButtonBox[\(\[SelectionPlaceholder] +\[Placeholder]\)], 
        ButtonBox[\(\[SelectionPlaceholder] -\[Placeholder]\)], 
        ButtonBox[\(\[SelectionPlaceholder]\[Times]\[Placeholder]\)], 
        ButtonBox[\(\[SelectionPlaceholder]\/\[Placeholder]\)]},
      {
        ButtonBox[\(-\[SelectionPlaceholder]\)], 
        ButtonBox[\(\[SelectionPlaceholder]\^\[Placeholder]\)], 
        ButtonBox[\(\@\[SelectionPlaceholder]\)], 
        ButtonBox[\(\@\[SelectionPlaceholder]\%\[Placeholder]\)]}
      },
    RowSpacings->0,
    ColumnSpacings->0,
    GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell[TextData[
"Numericalize to machine precision, or to specified arbitrary precision.\
\[AutoOperand]"], "Text",
  CellMargins->{{Inherited, Inherited}, {0, Inherited}}],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(N[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(N[\[SelectionPlaceholder], \[Placeholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Algebra", "Section"],

Cell[CellGroupData[{

Cell["Solving Equations", "Subsection"],

Cell[TextData[{
  "Solve an equation of the form ",
  StyleBox["lhs",
    FontSlant->"Italic"],
  "\[Equal]",
  StyleBox["rhs",
    FontSlant->"Italic"],
  " for some variable, or a system of equations for multiple variables."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Equal]\[Placeholder]\)]},
        {
          ButtonBox[\(Solve[\[SelectionPlaceholder] \[Equal]\[Placeholder], 
              \[Placeholder]]\)]},
        {
          ButtonBox[\(Solve[{\[SelectionPlaceholder] \[Equal]\[Placeholder], 
                \[Placeholder] \[Equal]\[Placeholder]}, 
              \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ {\[Placeholder], 
                \[Placeholder]}]\),
            ButtonData:>
              "Solve[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]\[Equal]\[Placeholder]},{\[Placeholder],\[Placeholder]}]"]},
        {
          ButtonBox[\(NSolve[\[SelectionPlaceholder] \[Equal]\[Placeholder], 
              \[Placeholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomial Manipulation", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Expand[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Factor[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Together[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Apart[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Cancel[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      RowLines->{False, False, False, False, True, False, True, False, False, 
          False, False, True, False}]], "Input",
  Active->True,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None],

Cell[TextData[{
  StyleBox["Simplify",
    FontFamily->"Courier"],
  " tries various manipulations to make expressions smaller. ",
  StyleBox["FullSimplify",
    FontFamily->"Courier"],
  " tries more manipulations, but takes longer. "
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Simplify[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(FullSimplify[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      RowLines->{False, False, False, False, True, False, True, False, False, 
          False, False, True, False}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Complex Numbers", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder] +\[Placeholder] I\)]},
        {GridBox[{
              {
                ButtonBox[\(Re[\[SelectionPlaceholder]]\)], 
                ButtonBox[\(Im[\[SelectionPlaceholder]]\)]},
              {
                ButtonBox[\(Abs[\[SelectionPlaceholder]]\)], 
                ButtonBox[\(Arg[\[SelectionPlaceholder]]\)]}
              },
            RowSpacings->0,
            ColumnSpacings->0,
            GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]},
        {
          ButtonBox[\(Conjugate[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  FormatType->TextForm],

Cell[TextData[{
  StyleBox["PowerExpand",
    FontFamily->"Courier"],
  " assumes that variables are positive real, with integer exponents, while ",
  
  StyleBox["ComplexExpand",
    FontFamily->"Courier"],
  " assumes all variables are real."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(PowerExpand[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(ComplexExpand[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      RowLines->{False, False, False, False, True, False, True, False, False, 
          False, False, True, False}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lists and Matrices", "Section"],

Cell[CellGroupData[{

Cell["Creating Lists and Matrices", "Subsection"],

Cell[TextData[{
  "When entering vectors and matrices, add rows by typing ",
  StyleBox["\[ControlKey]\[LeftModified]\[ReturnIndicator]\[RightModified]", 
    "Output"],
  " and add columns by typing ",
  StyleBox["\[ControlKey]\[LeftModified],\[RightModified]", "Output"],
  "."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"(", GridBox[{
                  {"\[Placeholder]"},
                  {"\[Placeholder]"}
                  }], ")"}]], 
          ButtonBox[
            RowBox[{"(", GridBox[{
                  {"\[Placeholder]", "\[Placeholder]"}
                  }], ")"}]], "\[AutoOperand]", 
          ButtonBox[
            RowBox[{"(", GridBox[{
                  {"\[Placeholder]", "\[Placeholder]"},
                  {"\[Placeholder]", "\[Placeholder]"}
                  }], ")"}]]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell[TextData[{
  "One way to create lists and matrices automatically is to iterate a \
variable over a range of values with ",
  StyleBox["Table",
    FontFamily->"Courier"],
  ", using the iterator {",
  StyleBox["var",
    FontSlant->"Italic"],
  ", ",
  StyleBox["min",
    FontSlant->"Italic"],
  ", ",
  StyleBox["max",
    FontSlant->"Italic"],
  "} or {",
  StyleBox["var",
    FontSlant->"Italic"],
  ", ",
  StyleBox["min",
    FontSlant->"Italic"],
  ", ",
  StyleBox["max",
    FontSlant->"Italic"],
  ", ",
  StyleBox["increment",
    FontSlant->"Italic"],
  "}. Many math functions accept lists as arguments where they operate on \
each element of the list."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Table[\[SelectionPlaceholder], {\[Placeholder], 
                \[Placeholder], \[Placeholder]}]\)]},
        {
          ButtonBox[\(Table[\[SelectionPlaceholder], {\[Placeholder], 
                \[Placeholder], \[Placeholder], \[Placeholder]}]\)]},
        {
          ButtonBox[\(Table[\[SelectionPlaceholder], {\[Placeholder], 
                \[Placeholder], \[Placeholder]}, 
              \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {\[Placeholder], 
                \[Placeholder], \[Placeholder]}]\),
            ButtonData:>
              "Table[\[SelectionPlaceholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrix Operations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder].\[Placeholder]\)]},
        {
          ButtonBox[\(Cross[\[SelectionPlaceholder], \[Placeholder]]\)]},
        {
          ButtonBox[\(Outer[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\)]},
        {
          ButtonBox[\(Det[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Inverse[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Transpose[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Eigenvalues[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Eigenvectors[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(LinearSolve[\[SelectionPlaceholder], 
              \[Placeholder]]\)]},
        {
          ButtonBox[\(RowReduce[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Trigonometric and Exponential Functions", "Section"],

Cell[CellGroupData[{

Cell["Trigonometric", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Sin[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(ArcSin[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Cos[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(ArcCos[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Tan[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(ArcTan[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnsEqual->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell["\<\
Manipulation of trigonometric expressions to alternate forms.\
\>", 
  "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(TrigExpand[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(TrigFactor[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(TrigReduce[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(ExpToTrig[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(TrigToExp[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      RowLines->{False, False, False, False, True, False, True, False, False, 
          False, False, True, False}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exponential and Logarithmic", "Subsection"],

Cell[TextData[{
  StyleBox["Log[10,\[ThinSpace]x]",
    FontFamily->"Courier"],
  " is the base 10 logarithm."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Log[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(Log[10, \ \[SelectionPlaceholder]]\)], 
          ButtonBox[\(Exp[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperbolic", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Sinh[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(ArcSinh[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Cosh[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(ArcCosh[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Tanh[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(ArcTanh[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnsEqual->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Calculus", "Section"],

Cell[CellGroupData[{

Cell["Common Operations", "Subsection"],

Cell[TextData[{
  Cell[BoxData[
      \(\[PartialD]\_x f[x]\)]],
  " is the derivative of ",
  StyleBox["f[x]",
    FontFamily->"Courier"],
  " with respect to ",
  StyleBox["x",
    FontFamily->"Courier"],
  ", while ",
  Cell[BoxData[
      \(\[PartialD]\_\(x, y\)f[x, y]\)]],
  " is the derivative with respect to x and y."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{
              StyleBox["\[Integral]",
                ScriptLevel->0], 
              RowBox[{"\[SelectionPlaceholder]", 
                StyleBox["\[ThinSpace]",
                  ScriptLevel->0], 
                StyleBox[\(\[DifferentialD]\[Placeholder]\),
                  ScriptLevel->0]}]}]], 
          ButtonBox[
            \(\[PartialD]\_\[Placeholder]\ \[SelectionPlaceholder]\)]},
        {
          ButtonBox[
            RowBox[{
              StyleBox[\(\[Integral]\_\[Placeholder]\%\[Placeholder]\),
                ScriptLevel->0], 
              RowBox[{"\[SelectionPlaceholder]", 
                StyleBox["\[ThinSpace]",
                  ScriptLevel->0], 
                StyleBox[\(\[DifferentialD]\[Placeholder]\),
                  ScriptLevel->0]}]}]], 
          ButtonBox[\(\[PartialD]\_\(\[Placeholder], 
                \[Placeholder]\)\[SelectionPlaceholder]\)]},
        {
          ButtonBox[
            RowBox[{
              StyleBox[
                \(\[Sum]\+\(\[Placeholder] \
=\[Placeholder]\)\%\[Placeholder]\),
                ScriptLevel->0], 
              StyleBox[" ",
                ScriptLevel->0], "\[SelectionPlaceholder]"}]], 
          ButtonBox[
            RowBox[{
              StyleBox[
                \(\[Product]\+\(\[Placeholder] =\[Placeholder]\)\%\
\[Placeholder]\),
                ScriptLevel->0], 
              StyleBox[" ",
                ScriptLevel->0], "\[SelectionPlaceholder]"}]]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"],

Cell[TextData[{
  "Series expansions are expressed in terms of a variable at a point for a \
given number of terms in the form {",
  StyleBox["var",
    FontSlant->"Italic"],
  ", ",
  StyleBox["point",
    FontSlant->"Italic"],
  ", ",
  StyleBox["terms",
    FontSlant->"Italic"],
  "}."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Limit[\[SelectionPlaceholder], \[Placeholder] 
                \[Rule]\[Placeholder]]\)]},
        {
          ButtonBox[\(Series[\[SelectionPlaceholder], {\[Placeholder], 
                \ \[Placeholder], \ \[Placeholder]}]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Differential Equations", "Subsection"],

Cell["\<\
Solve a differential equation, specifying the equation, the \
function to be found, and the variable. You may give initial conditions in \
the form of equations. \
\>", "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(DSolve[\[SelectionPlaceholder]\  
                \[Equal]\ \[Placeholder], \ \[Placeholder], 
              \ \[Placeholder]]\)]},
        {
          ButtonBox[\(DSolve[{\[SelectionPlaceholder]\  
                  \[Equal]\ \[Placeholder], \ \[Placeholder]\  
                  \[Equal]\ \[Placeholder]}, 
              \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \[Placeholder], 
              \ \[Placeholder]]\),
            ButtonData:>
              "DSolve[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]\[Equal]\[Placeholder]},\[Placeholder],\[Placeholder]]"]},
        {
          ButtonBox[\(DSolve[{\[SelectionPlaceholder]\  
                  \[Equal]\ \[Placeholder], \ \[Placeholder]\  
                  \[Equal]\ \[Placeholder]}, 
              \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {\[Placeholder], 
                \ \[Placeholder]}, \ \[Placeholder]]\),
            ButtonData:>
              "DSolve[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]\[Equal]\[Placeholder]},{\[Placeholder],\[Placeholder]},\
\[Placeholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"],

Cell[TextData[{
  "A numeric method can be used where a range is specified for the variable \
in the form ",
  StyleBox["{var,\[ThinSpace]min,\[ThinSpace]max}",
    FontFamily->"Courier"],
  "."
}], "Text"],

Cell[BoxData[
    ButtonBox[\(NDSolve[{\[SelectionPlaceholder]\  \[Equal]\ \[Placeholder], 
          \ \[Placeholder]\  \[Equal]\ \[Placeholder]}, 
        \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \[Placeholder], 
        \ {\[Placeholder], \ \[Placeholder], \ \[Placeholder]}]\),
      ButtonData:>
        "NDSolve[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\[Placeholder]\
\[Equal]\[Placeholder]},\[Placeholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]}]"]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numeric Root Finding", "Subsection"],

Cell["\<\
If you can't solve an equation exactly, you may be able to find particular \
numeric solutions using methods that require one or two starting points for \
finding the solution. You may also solve systems of equations this way.\
\>", "Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[
            \(FindRoot[\[SelectionPlaceholder] \[Equal] \[Placeholder], 
              \ {\[Placeholder], \ \[Placeholder]}]\)]},
        {
          
          ButtonBox[
            \(FindRoot[\[SelectionPlaceholder] \[Equal] \[Placeholder], \n
              \t\ \ \ \ \ \ \ \ \ {\[Placeholder], 
                \ {\[Placeholder], \ \[Placeholder]}}]\),
            
            ButtonData:>
              "FindRoot[\[SelectionPlaceholder]\[Equal]\[Placeholder],{\
\[Placeholder],{\[Placeholder],\[Placeholder]}}]"]},
        {
          
          ButtonBox[
            \(FindRoot[{\[SelectionPlaceholder] \[Equal] \[Placeholder], \ 
                \[Placeholder] \[Equal] \[Placeholder]}, \n
              \t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {
                \[Placeholder], \ \[Placeholder]}, 
              \ {\[Placeholder], \ \[Placeholder]}]\),
            
            ButtonData:>
              "FindRoot[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]\[Equal]\[Placeholder]},{\[Placeholder],\[Placeholder]},{\
\[Placeholder],\[Placeholder]}]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Functions", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains a large number of functions, of which only a small fraction can \
be found in this palette. The following two sections contain a few of the \
additional math functions."
}], "Text"],

Cell[CellGroupData[{

Cell["Integer Functions", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Floor[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Ceiling[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Round[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Chop[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Mod[\[SelectionPlaceholder], \[Placeholder]]\)]},
        {
          ButtonBox[\(Quotient[\[SelectionPlaceholder], \[Placeholder]]\)]},
        {
          ButtonBox[\(GCD[\[SelectionPlaceholder], \[Placeholder]]\)]},
        {
          ButtonBox[\(LCM[\[SelectionPlaceholder], \[Placeholder]]\)]},
        {
          ButtonBox[\(FactorInteger[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Rationalize[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Special Functions", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder]!\)]},
        {
          ButtonBox[\(BesselI[\[Placeholder], \[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(BesselJ[\[Placeholder], \[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(BesselK[\[Placeholder], \[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(BesselY[\[Placeholder], \[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Erf[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Gamma[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Zeta[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics", "Section"],

Cell[TextData[{
  "Many plotting functions take a function or list of functions as the first \
argument, and variable ranges in the form of {",
  StyleBox["var",
    FontSlant->"Italic"],
  ", ",
  StyleBox["min",
    FontSlant->"Italic"],
  ", ",
  StyleBox["max",
    FontSlant->"Italic"],
  "} as additional arguments."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Plot[\[SelectionPlaceholder], {\[Placeholder], 
                \[Placeholder], \[Placeholder]}]\)]},
        {
          ButtonBox[\(Plot[{\[SelectionPlaceholder], 
                \[Placeholder]}, {\[Placeholder], \[Placeholder], 
                \[Placeholder]}]\)]},
        {
          ButtonBox[\(ParametricPlot[{\[SelectionPlaceholder], 
                \[Placeholder]}, 
              \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ {\[Placeholder], \[Placeholder], 
                \[Placeholder]}]\),
            ButtonData:>
              "ParametricPlot[{\[SelectionPlaceholder],\[Placeholder]},{\
\[Placeholder],\[Placeholder],\[Placeholder]}]"]},
        {
          ButtonBox[\(Plot3D[\[SelectionPlaceholder], 
              \n\t\ \ {\[Placeholder], \[Placeholder], 
                \[Placeholder]}, {\[Placeholder], \[Placeholder], 
                \[Placeholder]}]\),
            ButtonData:>
              "Plot3D[\[SelectionPlaceholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]"]},
        {
          ButtonBox[\(ParametricPlot3D[\n\t\ \ \ \ \ \ \ {
                \[SelectionPlaceholder], \[Placeholder], \[Placeholder]}, 
              \n\ \ \ \ \ \ \ \t{\[Placeholder], \[Placeholder], 
                \[Placeholder]}]\),
            ButtonData:>
              "ParametricPlot3D[{\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]"]},
        {
          ButtonBox[\(ParametricPlot3D[\n\t\ \ \ \ {\[SelectionPlaceholder], 
                \[Placeholder], \[Placeholder]}, \n\t\ \ \ \ {\[Placeholder], 
                \[Placeholder], \[Placeholder]}, {\[Placeholder], 
                \[Placeholder], \[Placeholder]}]\),
            ButtonData:>
              "ParametricPlot3D[{\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]},{\[Placeholder]\
,\[Placeholder],\[Placeholder]}]"]},
        {
          ButtonBox[\(ContourPlot[\[SelectionPlaceholder], 
              \n\t\ \ \ {\[Placeholder], \[Placeholder], 
                \[Placeholder]}, {\[Placeholder], \[Placeholder], 
                \[Placeholder]}]\),
            ButtonData:>
              "ContourPlot[\[SelectionPlaceholder],{\[Placeholder],\
\[Placeholder],\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]\
"]},
        {
          ButtonBox[\(DensityPlot[\[SelectionPlaceholder], 
              \n\t\ \ \ {\[Placeholder], \[Placeholder], 
                \[Placeholder]}, {\[Placeholder], \[Placeholder], 
                \[Placeholder]}]\),
            ButtonData:>
              "DensityPlot[\[SelectionPlaceholder],{\[Placeholder],\
\[Placeholder],\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]\
"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnAlignments->{Left},
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell[TextData[{
  "To plot data, or lists of numbers, use ",
  StyleBox["ListPlot",
    FontFamily->"Courier"],
  ". It takes a list of ",
  StyleBox["y",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  " values, or ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["x",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["y",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " pairs. The points can be made into a line . ",
  StyleBox["ListPlot3D",
    FontFamily->"Courier"],
  " only accepts an array of z values."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(ListPlot[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(ListPlot[\[SelectionPlaceholder], \n\tPlotJoined 
                \[Rule]True]\),
            ButtonData:>
              "ListPlot[\[SelectionPlaceholder],PlotJoined\[Rule]True]"]},
        {
          ButtonBox[\(ListPlot3D[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnAlignments->{Left},
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
Editable->False,
WindowSize->{225, 461},
WindowMargins->{{Automatic, 5}, {Automatic, 2}},
WindowFrame->"Palette",
WindowElements->"VerticalScrollBar",
WindowClickSelect->False,
WindowTitle->None,
ShowCellBracket->False,
Active->True,
StyleDefinitions -> Notebook[{
  Cell["\<\
          Prototypes for the BasicCalculations Palette. This abbreviated \
style sheet is used to reduce the size of the notebook as a whole while still \
allowing the styles to be easily modifed. Remember that all other styles will \
be adopted from the default style sheet.          \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->None,
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{19, Inherited}, {3, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{24, Inherited}, {Inherited, 20}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, 20}},
    FontSize->14],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->None,
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{25, Inherited}, {Inherited, 8}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{24, Inherited}, {Inherited, 15}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, 15}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    ShowCellBracket->False,
    CellMargins->{{6, Inherited}, {0, Inherited}},
    FontFamily->"Times"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, Inherited}, {10, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{14, Inherited}, {0, Inherited}},
    FontSize->10],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{4, Inherited}, {0, 2}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    ShowCellBracket->False,
    CellMargins->{{5, Inherited}, {Inherited, Inherited}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{45, Inherited}, {20, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{30, Inherited}, {10, Inherited}},
    FontSize->10],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->10]
  }, Closed]]
  }]
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1732, 51, 41, 0, 39, "Section"],
Cell[1776, 53, 654, 14, 54, "Input"],
Cell[2433, 69, 171, 3, 32, "Text"],
Cell[2607, 74, 281, 7, 25, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[2925, 86, 26, 0, 25, "Section"],

Cell[CellGroupData[{
Cell[2976, 90, 39, 0, 29, "Subsection"],
Cell[3018, 92, 238, 8, 46, "Text"],
Cell[3259, 102, 832, 19, 90, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4128, 126, 45, 0, 25, "Subsection"],
Cell[4176, 128, 973, 29, 89, "Input",
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False],
Cell[5152, 159, 247, 7, 59, "Text"],
Cell[5402, 168, 328, 8, 41, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5767, 181, 37, 0, 25, "Subsection"],
Cell[5807, 183, 759, 20, 74, "Input"],
Cell[6569, 205, 256, 8, 58, "Text"],
Cell[6828, 215, 332, 8, 41, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7209, 229, 37, 0, 25, "Section"],

Cell[CellGroupData[{
Cell[7271, 233, 49, 0, 26, "Subsection"],
Cell[7323, 235, 291, 7, 48, "Text"],
Cell[7617, 244, 677, 19, 41, "Input"],
Cell[8297, 265, 684, 28, 103, "Text"],
Cell[8984, 295, 863, 18, 74, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[9884, 318, 39, 0, 22, "Subsection"],
Cell[9926, 320, 956, 26, 169, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10931, 352, 58, 0, 43, "Section"],

Cell[CellGroupData[{
Cell[11014, 356, 35, 0, 26, "Subsection"],
Cell[11052, 358, 548, 14, 57, "Input"],
Cell[11603, 374, 88, 3, 30, "Text"],
Cell[11694, 379, 545, 14, 89, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[12276, 398, 49, 0, 22, "Subsection"],
Cell[12328, 400, 122, 4, 18, "Text"],
Cell[12453, 406, 331, 8, 25, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[12821, 419, 32, 0, 22, "Subsection"],
Cell[12856, 421, 554, 14, 57, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13459, 441, 27, 0, 25, "Section"],

Cell[CellGroupData[{
Cell[13511, 445, 39, 0, 29, "Subsection"],
Cell[13553, 447, 338, 13, 48, "Text"],
Cell[13894, 462, 1600, 44, 121, "Input"],
Cell[15497, 508, 301, 12, 46, "Text"],
Cell[15801, 522, 353, 9, 41, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[16191, 536, 44, 0, 25, "Subsection"],
Cell[16238, 538, 186, 4, 60, "Text"],
Cell[16427, 544, 1195, 26, 91, "Input"],
Cell[17625, 572, 206, 6, 47, "Text"],
Cell[17834, 580, 485, 8, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[18356, 593, 42, 0, 25, "Subsection"],
Cell[18401, 595, 250, 4, 106, "Text"],
Cell[18654, 601, 1222, 31, 113, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19925, 638, 34, 0, 25, "Section"],
Cell[19962, 640, 262, 6, 74, "Text"],

Cell[CellGroupData[{
Cell[20249, 650, 39, 0, 26, "Subsection"],
Cell[20291, 652, 903, 24, 169, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[21231, 681, 39, 0, 22, "Subsection"],
Cell[21273, 683, 754, 20, 137, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22076, 709, 27, 0, 25, "Section"],
Cell[22106, 711, 334, 12, 60, "Text"],
Cell[22443, 725, 2985, 63, 269, "Input"],
Cell[25431, 790, 651, 25, 77, "Text"],
Cell[26085, 817, 537, 14, 74, "Input"]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

